var samplePageObj = {
  // 샘플 타이틀
  title: '저장 데이터 유효성 검증',
  subtitle: '시트의 데이터를 서버로 전송하기 전에 유효성을 검사하는 방법을 확인합니다.',
  // 샘플 설명
  desc: '<strong>onSave</strong> 이벤트는 데이터를 서버로 보내기전에 발생하는 이벤트입니다. <br>이 이벤트에서 전송될 데이터를 검사하고 리턴값에 따라 서버로 전송할지 중단할지를 판단할 수 있습니다.<br/>현재 샘플에서는 보내는 데이터에 <strong>\'굿바이 싱글\'</strong>이 포함되어 있는 경우 서버 전송을 중단하게 끔 되어 있습니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      Alternate: 2
    },
    Def: {
      Row: {
        Menu: {
          Items: [
            {
              Name: '신규 행 추가',
              Value: 'INS',
              Icon: './assets/imgs/bullet.gif',
              IconWidth: 3
            },
            {
              Name: '행 삭제',
              Value: 'DEL',
              Icon: './assets/imgs/bullet.gif',
              IconWidth: 3
            }
          ],
          OnSave: menuSave
        }
      },
      Col: {
        RelWidth: 1 // 컬럼에 들어가는 셀의 상대적인 크기 설정 (자유로운 기준치를 설정가능)
      }
    },
    LeftCols: [
      {
      // 컬럼 헤더 설정
        Header: 'No.', // 헤더 로우의 SEQ 컬럼에 해당하는 셀에 표시될 title 값
        Name: 'SEQ', // colName 컬럼명을 설정 (Data와 Matching)
        RelWidth: 0,
        Type: 'Int', // 컬럼 타입 설정 : Html, Text, Int, Float, Button, Lines, Enum, Radio, Img, Link, Icon, Bool
        Width: 60, // 컬럼의 너비 기본 너비 설정(px)
        Align: 'Center' // 컬럼의 내용 정렬 방식 설정 {"Left": 좌측 정렬,"Center": 가운데 정렬,"Right": 우측 정렬}
      }
    ],
    Cols: [
      {
        Header: {
          Value: '추천',
          Align: 'Center',
          Icon: 'Check', // sCheck 컬럼에 해당하는 헤더 로우의 셀 내 왼쪽 사이드에 표시될 아이콘
          HeaderCheck: 1 // 헤더의 체크박스를 클릭하면 데이터의 체크박스를 선택하는 기능 사용 여부
        },
        Name: 'sCheck',
        Type: 'Bool',
        MaxWidth: 80
      },
      {
        Header: '국가',
        Name: 'sNation',
        RelWidth: 1, // 컬럼에 들어가는 셀의 상대적인 크기 설정 (자유로운 기준치를 설정가능)
        Type: 'Enum',
        Enum: '|한국|미국|일본|영국|캐나다|이탈리아|스웨덴|중국|프랑스' // 선택할 값들의 리스트를 콤보 형태로 표현
      },
      {
        Header: '영화명',
        Name: 'sTitle',
        Required: 1,
        RelWidth: 2,
        MinWidth: 200, // 컬럼의 최소 너비(px)
      },
      {
        Header: '점유율',
        Name: 'sShare',
        Type: 'Float',
        Format: '0.#\\%' // 화면에 표시될 셀 값의 Format 형태를 설정. Int, Float 형식에서는 #를 숫자로 표현
      },
      {
        Header: '상영횟수',
        Type: 'Int',
        Name: 'sCount',
        Format: '#,###,### 명'
      },
      {
        Header: '개봉일',
        Name: 'sDate',
        Type: 'Date',
        Width: 120,
        Format: 'yyyy/MM/dd', // 화면에 표시될 셀 값의 Format 형태를 설정
        EditFormat: 'yyyy/MM/dd', // 셀 편집시 화면에 표시될 Format 형태를 설정
        DataFormat: 'yyyyMMdd' // 시트에 넣어질 Date 타입 데이터의 형식 **사용자의 데이터가 2018-07-20이면 yyyy-MM-dd로 설정

      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><button onclick=\'sampleBtn(this)\'>doSave</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 속성
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    if (arguments[0].innerText.match('doSave')) {
      var url = '/save_success.jsp';

      if (location.href.indexOf('localhost') > -1) {
        url = '../jsp/samples/customer' + url;
      } else {
        url = 'https://api.ibleaders.com/ibsheet/v8/samples/customer' + url;
      }

      sheet.doSave({
        url: url
      });
    }
  },

  // event구문
  event: {
    onSave: function (evtParam) {
      // doSave에서 서버로 요청을 보내기전 발생하는 이벤트
      var strChanges = evtParam.sheet.getSaveJson();

      if (strChanges.Message && strChanges.Message === 'RequiredError') {
        alert('필수 입력 항목 확인해주세요');

        return true;
      }

      strChanges = JSON.stringify(strChanges);
      if (decodeURI(strChanges).match(/굿바이 싱글/g)) { // 저장을 진행할지 여부를 검사하는 조건
        alert('잘못된 문자열이 포함되어 있습니다. 저장을 취소합니다.');

        return true; // true를 리턴하면 서버로 데이터를 보내지 않습니다.
      }
    },
    onAfterSave: function (evtParam) {
      // doSave가 실행된 후 서버에서 응답이 왔을 때 발생하는 이벤트.
      if (evtParam.result < 0) {
        alert('저장 실패');
      } else {
        alert('저장 성공');
      }
    }
  },

  // data
  data: [
    {
      sTitle: '굿바이 싱글',
      sShare: 23.1,
      sCount: 1585651,
      sDate: '20160629',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '봉이 김선달',
      sShare: 17.5,
      sCount: 1240336,
      sDate: '',
      sNation: '한국',
      sCheck: 1
    },
    {
      sTitle: '도리를 찾아서',
      sShare: 16.6,
      sCount: 1136765,
      sDate: '20160706',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '레전드 오브 타잔',
      sShare: 10.6,
      sCount: 692133,
      sDate: '20160629',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '사냥',
      sShare: 6,
      sCount: 409543,
      sDate: '20160629',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '나우 유 씨 미 2',
      sShare: 4.5,
      sCount: 303108,
      sDate: '20160713',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '인디펜던스 데이 : 리써전스',
      sShare: 4.4,
      sCount: 294139,
      sDate: '',
      sNation: '미국',
      sCheck: 1
    },
    {
      sTitle: '정글북',
      sShare: 3.4,
      sCount: 235827,
      sDate: '20160609',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '컨저링 2',
      sShare: 2.7,
      sCount: 184519,
      sDate: '20160609',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '특별수사: 사형수의 편지',
      sShare: 1.8,
      sCount: 124798,
      sDate: '',
      sNation: '한국',
      sCheck: 1
    },
    {
      sTitle: '아가씨',
      sShare: 1.7,
      sCount: 119240,
      sDate: '20160601',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '미 비포 유',
      sShare: 1.5,
      sCount: 102016,
      sDate: '20160601',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '500일의 썸머',
      sShare: 1.5,
      sCount: 98727,
      sDate: '20100121',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '잔예 - 살아서는 안되는 방',
      sShare: 0.6,
      sCount: 39707,
      sDate: '20160707',
      sNation: '일본',
      sCheck: 1
    },
    {
      sTitle: '빅뱅 메이드',
      sShare: 0.6,
      sCount: 39147,
      sDate: '20160630',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '나이스 가이즈',
      sShare: 0.3,
      sCount: 23830,
      sDate: '20160706',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '키즈모노가타리 I : 철혈편',
      sShare: 0.2,
      sCount: 15350,
      sDate: '20160630',
      sNation: '일본',
      sCheck: 0
    },
    {
      sTitle: '곡성',
      sShare: 0.2,
      sCount: 14255,
      sDate: '20160512',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '비밀은 없다',
      sShare: 0.2,
      sCount: 12402,
      sDate: '20160623',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '벤허',
      sShare: 0.2,
      sCount: 12401,
      sDate: '19720907',
      sNation: '미국',
      sCheck: 1
    },
    {
      sTitle: '서프러제트',
      sShare: 0.2,
      sCount: 11697,
      sDate: '20160623',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '본 투 비 블루',
      sShare: 0.2,
      sCount: 10954,
      sDate: '20160609',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '우리들',
      sShare: 0.1,
      sCount: 10605,
      sDate: '20160616',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '불의 전차',
      sShare: 0.1,
      sCount: 9517,
      sDate: '20160616',
      sNation: '영국',
      sCheck: 0
    },
    {
      sTitle: '극장판 프리즘스톤 올스타 셀렉션',
      sShare: 0.1,
      sCount: 8151,
      sDate: '20160707',
      sNation: '일본',
      sCheck: 0
    },
    {
      sTitle: '초속5센티미터',
      sShare: 0,
      sCount: 7098,
      sDate: '20070621',
      sNation: '일본',
      sCheck: 0
    },
    {
      sTitle: '언어의 정원',
      sShare: 0,
      sCount: 7098,
      sDate: '20130814',
      sNation: '일본',
      sCheck: 0
    },
    {
      sTitle: '밀림의 왕자 레오: 세상을 바꾸는 용기',
      sShare: 0.1,
      sCount: 6626,
      sDate: '20120229',
      sNation: '일본',
      sCheck: 0
    },
    {
      sTitle: '환상의 빛',
      sShare: 0.1,
      sCount: 6536,
      sDate: '20160707',
      sNation: '일본',
      sCheck: 0
    },
    {
      sTitle: '워크래프트: 전쟁의 서막',
      sShare: 0.1,
      sCount: 6393,
      sDate: '20160609',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '로렐',
      sShare: 0.1,
      sCount: 4858,
      sDate: '20160707',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '셀',
      sShare: 0.1,
      sCount: 4124,
      sDate: '20160629',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '싱 스트리트',
      sShare: 0,
      sCount: 3496,
      sDate: '20160519',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '본 얼티메이텀',
      sShare: 0.1,
      sCount: 3175,
      sDate: '20070912',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '계춘할망',
      sShare: 0,
      sCount: 2720,
      sDate: '20160519',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '오베라는 남자',
      sShare: 0,
      sCount: 2581,
      sDate: '20160525',
      sNation: '스웨덴',
      sCheck: 0
    },
    {
      sTitle: '리틀 폭스',
      sShare: 0,
      sCount: 2432,
      sDate: '20160623',
      sNation: '중국',
      sCheck: 0
    },
    {
      sTitle: '앵그리버드 더 무비',
      sShare: 0,
      sCount: 2238,
      sDate: '20160519',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '미친개들',
      sShare: 0,
      sCount: 1900,
      sDate: '20160707',
      sNation: '캐나다',
      sCheck: 0
    },
    {
      sTitle: '트릭',
      sShare: 0,
      sCount: 1817,
      sDate: '20160713',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '크리미널',
      sShare: 0,
      sCount: 1736,
      sDate: '20160622',
      sNation: '영국',
      sCheck: 0
    },
    {
      sTitle: '프렌치 캉캉',
      sShare: 0,
      sCount: 1729,
      sDate: '',
      sNation: '프랑스',
      sCheck: 0
    },
    {
      sTitle: '부산행',
      sShare: 0,
      sCount: 1721,
      sDate: '20160720',
      sNation: '한국',
      sCheck: 0
    },
    {
      sTitle: '소야곡',
      sShare: 0,
      sCount: 1618,
      sDate: '',
      sNation: '미국',
      sCheck: 0
    },
    {
      sTitle: '유리의 꽃과 부수는 세계',
      sShare: 0,
      sCount: 1556,
      sDate: '20160421',
      sNation: '일본',
      sCheck: 0
    },
    {
      sTitle: '헝그리 하트',
      sShare: 0,
      sCount: 1550,
      sDate: '20160630',
      sNation: '이탈리아',
      sCheck: 0
    },
    {
      sTitle: '아이 인 더 스카이',
      sShare: 0,
      sCount: 1454,
      sDate: '20160714',
      sNation: '영국',
      sCheck: 0
    },
    {
      sTitle: '일식',
      sShare: 0,
      sCount: 1387,
      sDate: '',
      sNation: '이탈리아',
      sCheck: 0
    },
    {
      sTitle: '바다 탐험대 옥토넛 시즌4: 아슬아슬 구조대작전',
      sShare: 0,
      sCount: 1376,
      sDate: '20160602',
      sNation: '영국',
      sCheck: 0
    },
    {
      sTitle: '우리 연애의 이력',
      sShare: 0,
      sCount: 1127,
      sDate: '20160629',
      sNation: '한국',
      sCheck: 0
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};

function menuSave(item, data) {
  if (item.Value == 'DEL') {
    sheet.deleteRow({ row: item.Owner.Row });
  } else if (item.Value == 'INS') {
    sheet.addRow({ next: item.Owner.Row });
  }
}
